/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.actions;

import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.expressions.WatchExpressionAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class PHPWatchAction
extends WatchExpressionAction
implements IWorkbenchWindowActionDelegate,
IEditorActionDelegate {
    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            action.setEnabled(textSelection.getLength() != 0);
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }

    public void run(IAction action) {
        IWorkbenchPage page;
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null && (page = DebugUIPlugin.getActiveWorkbenchWindow().getActivePage()) != null) {
            selection = page.getSelection();
        }
        if (selection instanceof TextSelection) {
            TextSelection textSelection = (TextSelection)selection;
            IExpressionManager expressionManager = DebugPlugin.getDefault().getExpressionManager();
            try {
                String expression = textSelection.getText();
                this.createExpression(expressionManager, expression);
            }
            catch (Exception e) {
                PHPDebugEPLPlugin.logError(e);
            }
        }
        this.displayResult(null);
    }

    protected void createExpression(IExpressionManager expressionManager, String expression) {
        IWatchExpression watchExpression = expressionManager.newWatchExpression(expression.trim());
        expressionManager.addExpression((IExpression)watchExpression);
        watchExpression.setExpressionContext(this.getContext());
    }

    protected void displayResult(IWatchExpressionResult result) {
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null) {
            try {
                activePage.showView("org.eclipse.debug.ui.ExpressionView");
            }
            catch (PartInitException e) {
                PHPDebugEPLPlugin.logError(e.getMessage(), e);
            }
        }
    }

    public void dispose() {
    }
}

